/*
 * Decompiled with CFR 0.152.
 */
package Project.Editor.sprites;

import BryceImages.ColorCalculators.RayMarching.BryceMath;
import BryceImages.Rendering.ColorCalculator;
import BryceMath.Calculations.Colors;
import BryceMath.Calculations.MathB;
import BryceMath.Calculations.Random_math;
import java.awt.Color;

public class ccWallCorner
extends ColorCalculator {
    int size;
    double block;
    final Color GRASS1 = Colors.Color_hsv(112.0, 77.0, 66.0);
    final int dir;

    public ccWallCorner(int width, int height, int dir) {
        super(width, height);
        this.size = width;
        this.block = (double)this.size / 2.0;
        this.antiAliasing = 3;
        this.dir = dir;
    }

    @Override
    public Color getColor(double x, double y) {
        int cy;
        int cx;
        int w = this.getWidth();
        int h = this.getHeight();
        int size = w / 3;
        switch (this.dir) {
            default: {
                cx = w;
                cy = h;
                break;
            }
            case 1: {
                cx = w;
                cy = 0;
                break;
            }
            case 0: {
                cx = 0;
                cy = 0;
                break;
            }
            case 2: {
                cx = 0;
                cy = h;
            }
        }
        if (BryceMath.sqrDistance(x, y, cx, cy) < (double)(size * size)) {
            return this.randomColor(28, 39, 30 + this.lineColor(x, y));
        }
        return Colors.C_CLEAR;
    }

    private int lineColor(double x, double y) {
        double seed;
        double v1 = this.adist(x, this.room_width);
        double v2 = this.adist(y, this.room_height);
        double v3 = this.adist(x, 0.0);
        double v4 = this.adist(y, 0.0);
        double output = seed = MathB.min(v1, v2, v3, v4);
        return Math.min((int)output, 10);
    }

    private double adist(double val1, double val2) {
        return Math.abs(val1 - val2);
    }

    private Color randomColor(int hue, int sat, int val) {
        return Colors.Color_hsv((double)hue + Random_math.random(-5, 5), (double)sat + Random_math.random(-5, 5), (double)val + Random_math.random(-5, 5));
    }
}

